<?php
header('Content-Type: application/json');
include '../includes/db.php';

// --- এখানে মূল পরিবর্তন করা হয়েছে ---
// সার্ভার HTTPS ব্যবহার করলে 'https' চেক করা হচ্ছে
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$base_url = $protocol . $_SERVER['SERVER_NAME'] . "/admin_panel/";

$response = array();
$videos = array();

$sql = "SELECT v.id, v.title, v.thumbnail_path, v.file_path, v.created_at, c.name AS category_name 
        FROM videos AS v 
        LEFT JOIN categories AS c ON v.category_id = c.id 
        ORDER BY v.id DESC";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $video_item = array(
            'id' => $row['id'],
            'title' => $row['title'],
            'thumbnail_url' => $base_url . $row['thumbnail_path'],
            'video_url' => $base_url . $row['file_path'],
            'category' => $row['category_name'] ?? 'N/A',
            'upload_date' => date("d M, Y", strtotime($row['created_at']))
        );
        array_push($videos, $video_item);
    }
    $response['status'] = 'success';
    $response['videos'] = $videos;
} else {
    $response['status'] = 'error';
    $response['message'] = 'No videos found';
}

echo json_encode($response);
$conn->close();
?>